/* File: BeeperDoublingKarel.java
 * 
 * A Karel program in which Karel doubles the number of beepers at
 * a given corner.  The world is assumed to be 3x1 with the beepers
 * in the center square and Karel at position (1, 1).
 */

import stanford.karel.*;

public class BeeperDoublingKarel extends SuperKarel {
	public void run() {
		move();
		doubleBeepers();
		moveBackward();
	}
	
	/* Precondition:  None
	 * Postcondition: Karel is facing the same direction, but one step backward.
	 */
	private void moveBackward() {
		turnAround();
		move();
		turnAround();
	}
	
	/* Precondition:  Karel is standing on a stack of N beepers and the next corner is empty.
	 * Postcondition: Karel is standing on a stack of 2N beepers and the next corner is empty.
	 */
	private void doubleBeepers() {
		doubleBeepersIntoNextCorner();
		moveNextCornerStackBack();
	}
	
	/* Precondition:  Karel is standing on a stack of N beepers and the next corner is empty.
	 * Postcondition: Karel is standing on an empty corner and the next corner has 2N beepers.
	 */
	private void doubleBeepersIntoNextCorner() {
		while (beepersPresent()) {
			doubleOneBeeperNextDoor();
		}
	}
	
	/* Precondition:  Karel is standing on a beeper.
	 * Postcondition: The next corner has two more beepers on it than before, and the original beeper
	 *                is no longer present.
	 */
	private void doubleOneBeeperNextDoor() {
		pickBeeper();
		move();
		putBeeper();
		putBeeper();
		moveBackward();
	}
	
	/* Precondition:  Karel is standing on an empty corner and there are 2N beepers on the next square.
	 * Postcondition: Karel is standing on 2N beepers and the next corner is empty.
	 */
	private void moveNextCornerStackBack() {
		move();
		transferPileBackward();
		moveBackward();
	}
	
	/* Precondition:  Karel is standing on 2N beepers and the previous corner is empty.
	 * Postcondition: Karel is standing on an empty corner and the previous corner has 2N beepers. 
	 */
	private void transferPileBackward() {
		while (beepersPresent()) {
			transferOneBeeperBackward();
		}
	}
	
	/* Precondition:  Karel is standing on a beeper.
	 * Postcondition: That beeper has been moved one corner backward.
	 */
	private void transferOneBeeperBackward() {
		pickBeeper();
		moveBackward();
		putBeeper();
		move();
	}
}